%% RUN4
clear 
close all
%   curentdir='H:\CIM\Potential Research\spatio-spectral modeling\chz_cc2011\Raw Database';
curentdir='/scratch/Soheila/MY MATLAB/Raw Database';

  img_ext='png';
  db_file='cc_gt.mat';

  in_dir=[curentdir];
 

  DB = open(db_file);
  
  N = length(DB.all_image_names);
  ae = zeros([N 3]);
  ei = zeros([N 3 3]);
  exe_t = zeros([N 3]);
  
  % Do precomputation
  pc_names = cell(N,1);
  scale=0.25;
  out_dir_name=['/ds','Author','_',num2str(scale)];
  out_dir=[curentdir,out_dir_name];
  mkdir(out_dir)
  save_name=['Author_',num2str(scale)];
  for i = 1:N
    tic
    i_name=[in_dir '/' DB.all_image_names{i} '.' img_ext];
    img1 = imread(i_name);
    img=imresize(img1,scale);
    if scale~=1
                  mask_crdnt=floor(DB.mask(i,:)*scale);
                  mask_crdnt=(mask_crdnt<1).*[1,1,1,1]+mask_crdnt;
                  mask_crdnt=mask_crdnt-(mask_crdnt>size(img1,1)).*[1,1,1,1];
                  mask_crdnt=mask_crdnt-(mask_crdnt>size(img1,2)).*[1,1,1,1];
    else
        mask_crdnt=DB.mask(i,:);
    end
    pc_names{i} = [out_dir '/' DB.all_image_names{i} '.pc.mat'];
    precompute1(double(img),pc_names{i}, mask_crdnt);
    precomputation_time(i)=toc;
    fprintf(' Precomputing for %s  exe_t: %4.2f\n',DB.all_image_names{i},precomputation_time(i));
  end;
  
  % Start testing
  svbase = [out_dir '/train'];
  truel = DB.groundtruth_illuminants;
  truel = truel ./ repmat(sqrt(sum(truel.^2,2)),[1 3]);

  
  for fold=1:3
      
      % ML
      tic
      train3fold(@train,pc_names,truel,svbase,fold)
      train_ML(fold)=toc
      [ae1 ei1 exe_t1] = test3fold(@estimate,out_dir,db_file,svbase,fold);
      ae(:,1) =ae(:,1)+ae1; ei(:,:,1) = ei(:,:,1)+ei1;exe_t(:,1) =exe_t(:,1)+exe_t1;
%       save precomputation_result
      
  end
        
  [mn1 md1 wst1]=report_errors(ae(:,1),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,1)));
  
for fold=1:3
      
      % General Prior
      tic
      train3fold(@trainPrior,pc_names,truel,svbase,fold)  
      train_GP(fold)=toc
      [ae2 ei2 exe_t2] = test3fold(@estimatePrior,out_dir,db_file,svbase,fold);
      ae(:,2) =ae(:,2)+ ae2; ei(:,:,2) = ei(:,:,2)+ ei2; exe_t(:,2) =exe_t(:,2)+exe_t2;
%       save precomputation_result
end

  [mn2 md2 wst2]=report_errors(ae(:,2),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,2)));

for fold=1:3
      
      % Prior WL 
      tic
      train3fold(@trainPriorWL,pc_names,truel,svbase,fold,DB.clabel)  
      train_WL(fold)=toc
      [ae3 ei3 exe_t3] = test3fold(@estimatePriorWL,out_dir,db_file,svbase,fold,DB.clabel);
      ae(:,3) =ae(:,3)+ ae3; ei(:,:,3) = ei(:,:,3)+ ei3; exe_t(:,3) =exe_t(:,3)+exe_t3;
%       save precomputation_result
end

  fprintf(' Average Execution Time: %d %d %d\n',mean(exe_t(:,1)),mean(exe_t(:,2)),mean(exe_t(:,3)));
  [mn1 md1 wst1]=report_errors(ae(:,1),DB.clabel,DB.categ_names);
  [mn2 md2 wst2]=report_errors(ae(:,2),DB.clabel,DB.categ_names);
  [mn3 md3 wst3]=report_errors(ae(:,3),DB.clabel,DB.categ_names);

  
save('save_name4','ae','exe_t','precomputation_time','train_ML','train_GP','train_WL','percentage')
  



%% RUN0
clear 
close all
%   curentdir='H:\CIM\Potential Research\spatio-spectral modeling\chz_cc2011\Raw Database';
curentdir='/scratch/Soheila/MY MATLAB/Raw Database';

  img_ext='png';
  db_file='cc_gt.mat';

  in_dir=[curentdir];
  
  DB = open(db_file);
  
  N = length(DB.all_image_names);
  ae = zeros([N 3]);
  ei = zeros([N 3 3]);
  exe_t = zeros([N 3]);
  
  % Do precomputation
  pc_names = cell(N,1);
  scale=0.5;
  out_dir_name=['/ds','Author','_',num2str(scale)];
  out_dir=[curentdir,out_dir_name];
  mkdir(out_dir)
  
  for i = 1:N
    tic
    i_name=[in_dir '/' DB.all_image_names{i} '.' img_ext];
    img1 = imread(i_name);
    img=imresize(img1,scale);
    if scale~=1
                  mask_crdnt=floor(DB.mask(i,:)*scale);
                  mask_crdnt=(mask_crdnt<1).*[1,1,1,1]+mask_crdnt;
                  mask_crdnt=mask_crdnt-(mask_crdnt>size(img1,1)).*[1,1,1,1];
                  mask_crdnt=mask_crdnt-(mask_crdnt>size(img1,2)).*[1,1,1,1];
    else
        mask_crdnt=DB.mask(i,:);
    end
    pc_names{i} = [out_dir '/' DB.all_image_names{i} '.pc.mat'];
    precompute1(double(img),pc_names{i}, mask_crdnt);
    precomputation_time(i)=toc;
    fprintf(' Precomputing for %s  exe_t: %4.2f\n',DB.all_image_names{i},precomputation_time(i));
  end;
  
  % Start testing
  svbase = [out_dir '/train'];
  truel = DB.groundtruth_illuminants;
  truel = truel ./ repmat(sqrt(sum(truel.^2,2)),[1 3]);

  
  for fold=1:3
      
      % ML
      tic
      train3fold(@train,pc_names,truel,svbase,fold)
      train_ML(fold)=toc
      [ae1 ei1 exe_t1] = test3fold(@estimate,out_dir,db_file,svbase,fold);
      ae(:,1) =ae(:,1)+ae1; ei(:,:,1) = ei(:,:,1)+ei1;exe_t(:,1) =exe_t(:,1)+exe_t1;
%       save precomputation_result
      
  end
        
  [mn1 md1 wst1]=report_errors(ae(:,1),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,1)));
  
for fold=1:3
      
      % General Prior
      tic
      train3fold(@trainPrior,pc_names,truel,svbase,fold)  
      train_GP(fold)=toc
      [ae2 ei2 exe_t2] = test3fold(@estimatePrior,out_dir,db_file,svbase,fold);
      ae(:,2) =ae(:,2)+ ae2; ei(:,:,2) = ei(:,:,2)+ ei2; exe_t(:,2) =exe_t(:,2)+exe_t2;
%       save precomputation_result
end

  [mn2 md2 wst2]=report_errors(ae(:,2),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,2)));

for fold=1:3
      
      % Prior WL 
      tic
      train3fold(@trainPriorWL,pc_names,truel,svbase,fold,DB.clabel)  
      train_WL(fold)=toc
      [ae3 ei3 exe_t3] = test3fold(@estimatePriorWL,out_dir,db_file,svbase,fold,DB.clabel);
      ae(:,3) =ae(:,3)+ ae3; ei(:,:,3) = ei(:,:,3)+ ei3; exe_t(:,3) =exe_t(:,3)+exe_t3;
%       save precomputation_result
end

  fprintf(' Average Execution Time: %d %d %d\n',mean(exe_t(:,1)),mean(exe_t(:,2)),mean(exe_t(:,3)));
  [mn1 md1 wst1]=report_errors(ae(:,1),DB.clabel,DB.categ_names);
  [mn2 md2 wst2]=report_errors(ae(:,2),DB.clabel,DB.categ_names);
  [mn3 md3 wst3]=report_errors(ae(:,3),DB.clabel,DB.categ_names);

  
save('save_name0','ae','exe_t','precomputation_time','train_ML','train_GP','train_WL','percentage')
  
  
  
  
  

      

